const db = require('../models');

const getAllUsers = async (req, res, next) => {
    try {
        const users = await db.User.findAll({ attributes: { exclude: ['passwordHash'] } });
        res.json(users);
    } catch (error) {
        next(error);
    }
};

const deleteUser = async (req, res, next) => {
    try {
        await db.User.destroy({ where: { id: req.params.userId } });
        res.json({ message: 'User deleted' });
    } catch (error) {
        next(error);
    }
};

const getAllTransactions = async (req, res, next) => {
    try {
        const transactions = await db.Transaction.findAll({
            include: [{ model: db.EmployerProfile, as: 'employer', attributes: ['companyName'] }]
        });
        res.json(transactions);
    } catch (error) {
        next(error);
    }
};

module.exports = { getAllUsers, deleteUser, getAllTransactions };