'use strict';
const {
  Model
} = require('sequelize');
module.exports = (sequelize, DataTypes) => {
  class EmployerProfile extends Model {
    static associate(models) {
      this.belongsTo(models.User, { foreignKey: 'userId', as: 'user' });
      this.hasMany(models.Job, { foreignKey: 'employerProfileId', as: 'jobs' });
      this.hasMany(models.Transaction, { foreignKey: 'employerProfileId', as: 'transactions' });
    }
  }
  EmployerProfile.init({
    userId: DataTypes.INTEGER,
    companyName: DataTypes.STRING,
    industry: DataTypes.STRING,
    website: DataTypes.STRING,
    logoUrl: DataTypes.STRING,
    description: DataTypes.TEXT
  }, {
    sequelize,
    modelName: 'EmployerProfile',
  });
  return EmployerProfile;
};