'use strict';
const {
  Model
} = require('sequelize');
module.exports = (sequelize, DataTypes) => {
  class JobSeekerProfile extends Model {
    static associate(models) {
      this.belongsTo(models.User, { foreignKey: 'userId', as: 'user' });
      this.hasMany(models.Application, { foreignKey: 'jobSeekerProfileId', as: 'applications' });
    }
  }
  JobSeekerProfile.init({
    userId: DataTypes.INTEGER,
    fullName: DataTypes.STRING,
    cvUrl: DataTypes.STRING,
    structuredProfileData: DataTypes.JSON
  }, {
    sequelize,
    modelName: 'JobSeekerProfile',
  });
  return JobSeekerProfile;
};