'use strict';
const {
  Model
} = require('sequelize');
module.exports = (sequelize, DataTypes) => {
  class User extends Model {
    static associate(models) {
      this.hasOne(models.EmployerProfile, { foreignKey: 'userId', as: 'employerProfile' });
      this.hasOne(models.JobSeekerProfile, { foreignKey: 'userId', as: 'jobSeekerProfile' });
    }
  }
  User.init({
    email: DataTypes.STRING,
    passwordHash: DataTypes.STRING,
    // Add fullName here
    fullName: DataTypes.STRING,
    role: {
      type: DataTypes.ENUM('Admin', 'Employer', 'Job Seeker'),
      allowNull: false
    }
  }, {
    sequelize,
    modelName: 'User',
  });
  return User;
};