const express = require('express');
const router = express.Router();
const { protect, hasRole } = require('../middleware/authMiddleware');
const { getAllUsers, deleteUser, getAllTransactions } = require('../controllers/adminController');

router.get('/users', protect, hasRole('Admin'), getAllUsers);
router.delete('/users/:userId', protect, hasRole('Admin'), deleteUser);
router.get('/transactions', protect, hasRole('Admin'), getAllTransactions);

module.exports = router;