const express = require('express');
const router = express.Router();
const { protect, hasRole } = require('../middleware/authMiddleware');
const { validateRequest, schemas } = require('../middleware/validationMiddleware');
const { createJob, getAllJobs, getJobById, getMyJobs } = require('../controllers/jobController');

router.post('/', protect, hasRole('Employer'), validateRequest(schemas.jobPost), createJob);
router.get('/', getAllJobs);
router.get('/my-jobs', protect, hasRole('Employer'), getMyJobs);
router.get('/:jobId', getJobById);

module.exports = router;