'use strict';
const bcrypt = require('bcryptjs');

/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {

    const salt = await bcrypt.genSalt(10);
    const passwordHash = await bcrypt.hash('password123', salt);
    const timestamp = new Date();

    // 1. Insert Users
    await queryInterface.bulkInsert('Users', [
      {
        id: 1,
        email: 'admin@bizhire.com',
        passwordHash: passwordHash,
        role: 'Admin',
        fullName: 'Super Admin', // Added
        createdAt: timestamp,
        updatedAt: timestamp
      },
      {
        id: 2,
        email: 'employer@techcorp.com',
        passwordHash: passwordHash,
        role: 'Employer',
        fullName: 'Elon Musk', // Added
        createdAt: timestamp,
        updatedAt: timestamp
      },
      {
        id: 3,
        email: 'john@seeker.com',
        passwordHash: passwordHash,
        role: 'Job Seeker',
        fullName: 'John Doe', // Added
        createdAt: timestamp,
        updatedAt: timestamp
      }
    ], { ignoreDuplicates: true }); // Prevent error if run multiple times without down

    // 2. Insert Employer Profile
    await queryInterface.bulkInsert('EmployerProfiles', [{
      id: 1,
      userId: 2,
      companyName: 'Tech Corp Solutions',
      industry: 'Software Development',
      website: 'https://techcorp.com',
      description: 'We build the future of tech.',
      createdAt: timestamp,
      updatedAt: timestamp
    }], { ignoreDuplicates: true });

    // 3. Insert Job Seeker Profile
    await queryInterface.bulkInsert('JobSeekerProfiles', [{
      id: 1,
      userId: 3,
      fullName: 'John Doe',
      cvUrl: 'uploads/cvs/dummy-cv.pdf',
      structuredProfileData: JSON.stringify({ skills: ['Node.js', 'React'] }),
      createdAt: timestamp,
      updatedAt: timestamp
    }], { ignoreDuplicates: true });

    // 4. Insert Jobs (Updated with new fields)
    await queryInterface.bulkInsert('Jobs', [
      {
        id: 1,
        employerProfileId: 1,
        title: 'Senior Node.js Developer',
        description: 'We are looking for a backend expert to join our team.',
        location: 'Remote',
        employmentType: 'Full-time',
        status: 'Active',
        // New Fields
        salaryRange: 'AED 20,000 - 25,000 / month',
        requirements: '• 5+ years Node.js experience\n• Experience with AWS\n• Strong SQL skills',
        createdAt: timestamp,
        updatedAt: timestamp
      },
      {
        id: 2,
        employerProfileId: 1,
        title: 'React Frontend Engineer',
        description: 'Join us to build beautiful UIs.',
        location: 'Dubai, UAE',
        employmentType: 'Full-time',
        status: 'Active',
        // New Fields
        salaryRange: 'AED 15,000 - 18,000 / month',
        requirements: '• 3+ years React experience\n• Tailwind CSS proficiency\n• Good eye for design',
        createdAt: timestamp,
        updatedAt: timestamp
      }
    ], { ignoreDuplicates: true });
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.bulkDelete('Jobs', null, {});
    await queryInterface.bulkDelete('JobSeekerProfiles', null, {});
    await queryInterface.bulkDelete('EmployerProfiles', null, {});
    await queryInterface.bulkDelete('Users', null, {});
  }
};